/**
 * 
 */
package com.ejie.ab18a.control;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ejie.ab18a.utils.Ab18aO75Utils;
import com.ejie.ab18a.utils.Constantes;
import com.ejie.ab18a.utils.Utilidades;

/**
 * @author XXXX
 * 
 */
@Controller()
@RequestMapping(value = "lanzarRecibirInformacion")
public class Ab18aLanzarRecibirInformacionController {

	private static final String AB18A_RECIBIR_INFORMACION_SH = "AB18AINFOR.sh";

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aLanzarRecibirInformacionController.class);

	/**
	 * Generacion informes batch.
	 * 
	 * @param request
	 *            the request
	 * @return the string
	 * @throws Exception
	 *             the exception
	 */
	@SuppressWarnings("unused")
	@RequestMapping(method = RequestMethod.GET)
	private String lanzarRecibirInformacionBatch(HttpServletRequest request) throws Exception {
		// realizar proceso batch
		String ficheroSH = AB18A_RECIBIR_INFORMACION_SH;

		String sDescripcion = "RECIBIR INFO";

		Ab18aO75Utils o75Utils = Ab18aO75Utils.getInstance();

		String resultado = o75Utils.lanzarProceso(request, ficheroSH, sDescripcion, null, null);

		if (Utilidades.notNullAndNotEmpty(resultado) && resultado.equalsIgnoreCase(Constantes.CTE_TRUE)) {
			return "ab18a02s00";
		} else {

			Ab18aLanzarRecibirInformacionController.logger.error("lanzarRecibirInformacionBatch: errorCodigo: " + o75Utils.getlErrorCodigo()
					+ ", Error descripcion: " + o75Utils.getsErrorDescripcion() + ", error motivo: " + o75Utils.getsErrorMotivo());

			return "error";
		}
	}
}
